clear 	 	all
set more 	off
***set cd here***

****Data and documentation for SIPP available at: http://www.nber.org/data/survey-of-income-and-program-participation-sipp-data.html****

********************************************************************************
*Figure 14: fifteen month-ahead hazard function for months 1-36.
********************************************************************************

use 	for_spell_not_emp, clear
sort 	panel_id date

local 	non_emp_dur_measure			not_emp_dummy_dur
local 	non_emp_spell_measure		not_emp_dummy_spell

*The lead length
foreach l in 15	 						{

*Count the weighted outcomes for EMP/UNEMP/NLF for all jobless spells of length `dur'
foreach var 	in 		any_emp	 		///
						unemployed 		///
						not_lf			{
forval	dur		=		1/36			{						
local 	lead	`l'
qui sum wpfinwgt 	if 	F`lead'.`var'_dummy 	==	1 		///
					& 	`non_emp_dur_measure' 	== `dur'	
di "`dur'" "   "	 r(sum)
}
}

*FTS outcome LEAD months later 
forval	dur		=		1/36			{
foreach var 	in 		fts				///
										{
local 	lead	`l'
qui sum wpfinwgt 	if F`lead'.`var'_dummy 		==	1 		///
					& `non_emp_dur_measure' 	== `dur'	///
					& F`lead'.fts_dummy_dur >3
di "`dur'" "   "	 r(sum)
}
}
}
*


